#include <bits/stdc++.h>
using namespace std;

const int MAXN = 1e6 + 5;

struct Interval {
  int lft, rig;
  Interval() : lft(MAXN), rig(-1) {}
  Interval(int lft, int rig) : lft(lft), rig(rig) {
    if (lft > rig)
      *this = Interval();
  }
  bool test(int val) const {
    return val >= lft && val <= rig;
  }
};

class MonoQueueMin {
  deque <int> q;
public:
  void add(int x) {
    while (!q.empty() && q.back() > x)
      q.pop_back();
    q.push_back(x);
  }
  void remove(int x) {
    if (!q.empty() && q.front() == x)
      q.pop_front();
  }
  int minimum() const {
    return q.empty() ? MAXN : q.front();
  }
};

class MonoQueueMax {
  deque <int> q;
public:
  void add(int x) {
    while (!q.empty() && q.back() < x)
      q.pop_back();
    q.push_back(x);
  }
  void remove(int x) {
    if (!q.empty() && q.front() == x)
      q.pop_front();
  }
  int maximum() const {
    return q.empty() ? -1 : q.front();
  }
};

int N, K;
char s[MAXN];
Interval diff[MAXN][2], same[MAXN][2];
int last[MAXN][2];

void load() {
  scanf("%d%d%s", &N, &K, s + 1);
}

bool check(int len) {
  vector <int> ptr(2);
  vector <MonoQueueMin> trans_min(2);
  vector <MonoQueueMax> trans_max(2);
  for (int k = 0; k < 2; k++) {
    same[0][k] = Interval(0, 0);
    trans_min[k].add(0);
    trans_max[k].add(0);
  }
  for (int i = 1; i <= N; i++) {
    for (int k = 0; k < 2; k++) {
      int pos = max(i - len, last[i][k ^ 1]);
      for (; ptr[k ^ 1] < pos; ptr[k ^ 1]++) {
        trans_min[k ^ 1].remove(same[ptr[k ^ 1]][k ^ 1].lft);
        trans_max[k ^ 1].remove(same[ptr[k ^ 1]][k ^ 1].rig);
      }
      diff[i][k] = Interval(trans_min[k ^ 1].minimum(), trans_max[k ^ 1].maximum());
      same[i][k] = Interval(i - diff[i][k].rig, i - diff[i][k].lft);
    }
    for (int k = 0; k < 2; k++) {
      trans_min[k].add(same[i][k].lft);
      trans_max[k].add(same[i][k].rig);
    }
  }
  return diff[N][0].test(K) || diff[N][1].test(N - K);
}

void solve() {
  for (int i = 1; i <= N; i++)
    for (int k = 0; k < 2; k++)
      last[i][k] = s[i] == "01"[k] ? i : last[i - 1][k];
  int lo = 0, hi = N + 1;
  while (lo < hi) {
    int mid = (lo + hi) / 2;
    if (check(mid))
      hi = mid;
    else
      lo = mid + 1;
  }
  printf("%d\n", lo);
  check(lo);
  int digit = 0, cnt = K;
  if (diff[N][1].test(N - K)) {
    cnt = N - K;
    digit = 1;
  }
  for (int i = N; i; i--) {
    s[i] = "01"[digit];
    if (same[i - 1][digit ^ 1].test(cnt)) {
      cnt = i - 1 - cnt;
      digit ^= 1;
    }
  }
  puts(s + 1);
}

int main() {
  load();
  solve();
  return 0;
}
